/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/
package cnrg.itx.datax.jaudio;

import java.io.*;
import java.util.*;

class JAudioTest 
{
	//////////////////////////////////////////////////////////////////////
	//																	//
	//				 CLASS MEMBER VARIABLES								//
	//																	//
	//////////////////////////////////////////////////////////////////////

	private static final String SYNTAX	= "Syntax: jaudio.JAudioTest [-d dev] [-s seconds]";
	public static final int RATE		= 8000;
	public static final int BITS		= 8;
	public static final int SAMPLE		= 100;

	//////////////////////////////////////////////////////////////////////
	//																	//
	//					  CLASS METHODS									//
	//																	//
	//////////////////////////////////////////////////////////////////////
	public static void main(String args[]) 
	{
		try 
		{
			// The JAudioDevice
			JAudioDevice inputAudioDevice;
			JAudioDevice outputAudioDevice;
			JAudioDevice duplexAudioDevice;
			JAudioBlock[] audioBlocks;
			JAudioBlock newAudioBlock;
			JAudioBlock clonedAudioBlock;

			// Default device and playback length
			int numDevices;
			int device = 0;
			int length = 5;

			// The total number of samples to take
			int numSamples = (((BITS/8)*RATE)/SAMPLE)*length;

			try 
			{
				// Get the CL args
				for(int i = 0; i < args.length; i++) 
				{
					if (args[i].equals("-d")) 
					{
							i++;
							device = Integer.parseInt(args[i]);
					} 
					else if (args[i].equals("-s")) 
					{
						i++;
						length = Integer.parseInt(args[i]);
					} 
					else 
					{
						throw new Exception();
					}
				}
			} 
			catch (Exception e) 
			{
				System.out.println(SYNTAX);
				return;				
			}

			// Make sure there's an audio device available
			if (JAudioDevice.getNumDevices() == 0)
			{
				System.out.println("JAudioTest: No devices available, exiting...");
				System.exit(-1);
			}

			// Allocate audio blocks
			System.out.println("JAudioTest: Allocating audio blocks.");
			audioBlocks = new JAudioBlock[numSamples];
			for (int i = 0; i < numSamples; i++)
			{
				audioBlocks[i] = new JAudioBlock(SAMPLE);
			}

			// Open the input audio device
			System.out.println("JAudioTest: Opening input device " + device);
			inputAudioDevice = new JAudioDevice(device, JAudioDevice.INPUT);

			// Open the output audio device
			System.out.println("JAudioTest: Opening output device " + device);
			outputAudioDevice = new JAudioDevice(device, JAudioDevice.OUTPUT);


			// Add the audio blocks to the input audio queue
			System.out.println("JAudioTest: Adding audio blocks to input queue.");
			for (int i = 0; i < numSamples; i++)
			{
				inputAudioDevice.in.addBlock(audioBlocks[i]);
			}

			// Record the audio
			System.out.println("JAudioTest: Recording " + length + " seconds of audio.");
			inputAudioDevice.in.start();
			audioBlocks[numSamples - 1].waitUntilFinished();
			
			// Stop the recording and close the device
			System.out.println("JAudioTest: Recording finished.");
			System.out.println("JAudioTest: Closing input device.");
			inputAudioDevice.in.stop();
			inputAudioDevice.close();

			// Playback audio
			System.out.println("JAudioTest: Playing back audio.");
			for (int i = 0; i < numSamples; i++)
			{
				outputAudioDevice.out.putBlock(audioBlocks[i]);
			}

			// Wait for playback to finish
			audioBlocks[numSamples - 1].waitUntilFinished();

			// Close input/output devices
			System.out.println("JAudioTest: Closing output device.");
			outputAudioDevice.close();

			// Open the duplex audio device
			System.out.println("JAudioTest: Opening duplex device " + device);
			duplexAudioDevice = new JAudioDevice(device, JAudioDevice.DUPLEX);

			// Try direct feedback
			System.out.println("JAudioTest: Direct feedback for " + length + " seconds.");
			duplexAudioDevice.in.start();
			for (int i = 0; i < numSamples; i++)
			{
				newAudioBlock = audioBlocks[i];
				duplexAudioDevice.in.addBlock(newAudioBlock);
				newAudioBlock.waitUntilFinished();
				duplexAudioDevice.out.putBlock(newAudioBlock);
			}
			duplexAudioDevice.in.stop();

			// Close the audio device
			System.out.println("JAudioTest: Closing audio device.");
			duplexAudioDevice.close();

			// All done...
			System.out.println("JAudioTest: Done.");
		}
		catch (Exception e) 
		{
			e.printStackTrace(System.out);
		}
	}
}
